//---------------------------------------------------------------------------------------------
// Torque Game Builder
// Copyright (C) GarageGames.com, Inc.
//---------------------------------------------------------------------------------------------
//
// This is the file you should define your custom datablocks that are to be used
// in the editor.
//
//============================================================================================================

new t2dImageMapDatablock(block2)
		{
			imageName = "~/data/images/Block2.png";
			//imageMode = "FULL";
			imageMode = "CELL";
			//frameCount = "-1";
			frameCount = "40";
			filterMode = "NONE";
			filterPad = "0";
			preferPerf = "1";
			cellRowOrder = "1";
			cellOffsetX = "0";
			cellOffsetY = "0";
			cellStrideX = "0";
			cellStrideY = "0";
			cellCountX = "40";
			cellCountY = "1";
			cellWidth = "240";
			cellHeight = "240";
			preload = "1";
			allowUnload = "0";
		};

new t2dImageMapDatablock(background)
		{
			imageName = "~/data/images/background.png";
			//imageMode = "FULL";
			imageMode = "FULL";
			//frameCount = "-1";
			frameCount = "-1";
			filterMode = "NONE";
			filterPad = "0";
			preferPerf = "1";
			cellRowOrder = "1";
			cellOffsetX = "0";
			cellOffsetY = "0";
			cellStrideX = "0";
			cellStrideY = "0";
			cellCountX = "40";
			cellCountY = "1";
			cellWidth = "240";
			cellHeight = "240";
			preload = "1";
			allowUnload = "0";
		};

new t2dImageMapDatablock(block1)
		{
			imageName = "~/data/images/Block1.png";
			//imageMode = "FULL";
			imageMode = "CELL";
			//frameCount = "-1";
			frameCount = "40";
			filterMode = "NONE";
			filterPad = "0";
			preferPerf = "1";
			cellRowOrder = "1";
			cellOffsetX = "0";
			cellOffsetY = "0";
			cellStrideX = "0";
			cellStrideY = "0";
			cellCountX = "40";
			cellCountY = "1";
			cellWidth = "240";
			cellHeight = "240";
			preload = "1";
			allowUnload = "0";
		};

function createBlockImageMaps()
{
	for(%i = 3; %i < 5; %i++)
	{
		%name = "Block" @ %i;
		new t2dImageMapDatablock(%name)
		{
			imageName = "~/data/images/Block" @ %i @ ".png";
			//imageMode = "FULL";
			imageMode = "CELL";
			//frameCount = "-1";
			frameCount = "40";
			filterMode = "NONE";
			filterPad = "0";
			preferPerf = "1";
			cellRowOrder = "1";
			cellOffsetX = "0";
			cellOffsetY = "0";
			cellStrideX = "0";
			cellStrideY = "0";
			cellCountX = "40";
			cellCountY = "1";
			cellWidth = "45";
			cellHeight = "45";
			preload = "1";
			allowUnload = "0";
		};
	}
	
	//create debris
	for(%i = 1; %i < 5; %i++)
	{
		for(%d = 1; %d < 3; %d++)
		{
			if(%d == 1)
				%size = 9;
			
			if(%d == 2)
				%size = 12;
			
			new t2dImageMapDatablock("block" @ %i @ "Debris" @ %d)
			{
				imageName = "~/data/images/Block" @ %i @ "Debris" @ %d @ ".png";
				imageMode = "CELL";
				frameCount = "21";
				filterMode = "NONE";
				filterPad = "0";
				preferPerf = "1";
				cellRowOrder = "1";
				cellOffsetX = "0";
				cellOffsetY = "0";
				cellStrideX = "0";
				cellStrideY = "0";
				cellCountX = "21";
				cellCountY = "1";
				cellWidth = %size;
				cellHeight = %size;
				preload = "1";
				allowUnload = "0";
				isDebris = 1;
				//animationSpeed = 20;
			};
		}
	}
}

createBlockImageMaps();

new t2dImageMapDatablock(centerConnect)
		{
			imageName = "~/data/images/centerConnect.png";
			imageMode = "FULL";
			frameCount = "-1";
			filterMode = "NONE";
			filterPad = "0";
			preferPerf = "1";
			cellRowOrder = "1";
			preload = "1";
			allowUnload = "0";
};
new t2dImageMapDatablock(upConnect)
		{
			imageName = "~/data/images/upConnect.png";
			imageMode = "CELL";
			frameCount = "6";
			filterMode = "NONE";
			cellCountX = "6";
			cellCountY = "1";
			cellWidth = "11";
			cellHeight = "23";
			filterPad = "0";
			preferPerf = "1";
			cellRowOrder = "1";
			preload = "1";
			allowUnload = "0";
};
new t2dImageMapDatablock(leftConnect)
		{
			imageName = "~/data/images/leftConnect.png";
			imageMode = "CELL";
			frameCount = "6";
			filterMode = "NONE";
			cellCountX = "6";
			cellCountY = "1";
			cellWidth = "23";
			cellHeight = "9";
			filterPad = "0";
			preferPerf = "1";
			cellRowOrder = "1";
			preload = "1";
			allowUnload = "0";
};
new t2dImageMapDatablock(rightConnect)
		{
			imageName = "~/data/images/rightConnect.png";
			imageMode = "CELL";
			frameCount = "6";
			filterMode = "NONE";
			cellCountX = "6";
			cellCountY = "1";
			cellWidth = "23";
			cellHeight = "9";
			filterPad = "0";
			preferPerf = "1";
			cellRowOrder = "1";
			preload = "1";
			allowUnload = "0";
};
new t2dImageMapDatablock(downConnect)
		{
			imageName = "~/data/images/downConnect.png";
			imageMode = "CELL";
			frameCount = "6";
			filterMode = "NONE";
			cellCountX = "6";
			cellCountY = "1";
			cellWidth = "11";
			cellHeight = "23";
			filterPad = "0";
			preferPerf = "1";
			cellRowOrder = "1";
			preload = "1";
			allowUnload = "0";
};


new t2dImageMapDatablock(explosionSmall)
		{
			imageName = "~/data/images/explosionSmall.png";
			imageMode = "CELL";
			frameCount = "50";
			filterMode = "NONE";
			cellCountX = "50";
			cellCountY = "1";
			cellWidth = "29";
			cellHeight = "29";
			filterPad = "0";
			preferPerf = "1";
			cellRowOrder = "1";
			preload = "1";
			allowUnload = "0";
			isExplosion = 1;
			animationSpeed = 8;
};

new t2dImageMapDatablock(explosionMedium)
		{
			imageName = "~/data/images/explosionMedium.png";
			imageMode = "CELL";
			frameCount = "55";
			filterMode = "NONE";
			cellCountX = "55";
			cellCountY = "1";
			cellWidth = "65";
			cellHeight = "65";
			filterPad = "0";
			preferPerf = "1";
			cellRowOrder = "1";
			preload = "1";
			allowUnload = "0";
			isExplosion = 1;
			animationSpeed = 10;
};

new t2dImageMapDatablock(explosionLarge)
		{
			imageName = "~/data/images/explosionLarge.png";
			imageMode = "CELL";
			frameCount = "55";
			filterMode = "NONE";
			cellCountX = "55";
			cellCountY = "1";
			cellWidth = "65";
			cellHeight = "65";
			filterPad = "0";
			preferPerf = "1";
			cellRowOrder = "1";
			preload = "1";
			allowUnload = "0";
			isExplosion = 1;
			animationSpeed = 22;
};
//=============================================================
function makeTestBlock()
{
	$test = new t2dStaticSprite()
			{
				imageMap = "block0";
				frame = "0";
				canSaveDynamicFields = "1";
				size = $blockSize;
				Layer = $blockLayer;
				position = "0 0";
				CollisionPolyList = "-0.496 -0.751 0.491 -0.751 0.491 0.742 -0.496 0.742";
				//LinkPoints = "0.000 0.000";
				//mountID = "2";
			};
	$sceneGraph.add($test);
	$test.startAnimate($animationTime);
}

function t2dStaticSprite::doAnimation(%this)
{
	%frame = %this.getFrame();
	
	if(%this.imageMap.isExplosion)
	{
		if(%frame >= %this.imageMap.frameCount - 1)
		{
			%this.schedule(5, delete);
			return;
		}
		%this.setFrame(%frame + 1);
		%this.schedule(%this.imageMap.animationSpeed, "doAnimation");
	}
	
	if(%this.imageMap.isDebris)
	{
		if(%frame >= %this.imageMap.frameCount - 1)
			%this.goingDown = 1;
			
		if(%frame <= 0)
			%this.goingDown = 0;
		
		if(%this.goingDown)
			%this.setFrame(%frame - 1);
		else
			%this.setFrame(%frame + 1);
		
		return;
	}
	
	if(%frame <= 0)
		%this.goingUp = 1;
	if(%frame >= %this.imageMap.frameCount - 1)
		%this.goingUp = 0;
	
	if(%this.goingUp == 1)
		%this.setFrame(%frame + 1);
	else
		%this.setFrame(%frame - 1);
}

function t2dStaticSprite::onPositionTarget(%this)
{
	if($Grid.movingDownGroup.isMember(%this))
		$Grid.movingDownGroup.remove(%this);
	
	if($Grid.movingDownGroup.getCount() == 0 && $updatedRow == 0)
	{
		$Grid.schedule(50, "updateRow");
	}
}

//particles - unused
new t2dImageMapDatablock(particles1ImageMap) {
      canSaveDynamicFields = "1";
      imageName = "./images/particles1";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "0";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "64";
      cellHeight = "64";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(particles2ImageMap) {
      canSaveDynamicFields = "1";
      imageName = "./images/particles2";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "0";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "128";
      cellHeight = "128";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(particles3ImageMap) {
      canSaveDynamicFields = "1";
      imageName = "./images/particles3";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "0";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "128";
      cellHeight = "128";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(particles4ImageMap) {
      canSaveDynamicFields = "1";
      imageName = "./images/particles4";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "0";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "64";
      cellHeight = "64";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(particles5ImageMap) {
      canSaveDynamicFields = "1";
      imageName = "./images/particles5";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "0";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "64";
      cellHeight = "64";
      preload = "1";
      allowUnload = "0";
   };
   new t2dImageMapDatablock(particles6ImageMap) {
      canSaveDynamicFields = "1";
      imageName = "./images/particles6";
      imageMode = "CELL";
      frameCount = "-1";
      filterMode = "SMOOTH";
      filterPad = "0";
      preferPerf = "0";
      cellRowOrder = "1";
      cellOffsetX = "0";
      cellOffsetY = "0";
      cellStrideX = "0";
      cellStrideY = "0";
      cellCountX = "-1";
      cellCountY = "-1";
      cellWidth = "64";
      cellHeight = "64";
      preload = "1";
      allowUnload = "0";
   };